@extends('layouts.modern')

@section('title', $blog->meta_title ?? $blog->title . ' - ENT Care Center')
@section('meta_description', $blog->meta_description ?? $blog->short_description)

@section('content')
<!-- Blog Detail -->
<section class="py-6 md:py-10 bg-gradient-to-br from-white to-gray-50">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Breadcrumb & Back -->
        <nav class="flex items-center text-sm text-gray-500 mb-6 md:mb-8">
            <a href="{{ route('home') }}" class="hover:text-blue-600 transition-colors">Home</a>
            <svg class="w-4 h-4 mx-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M9 5l7 7-7 7"></path></svg>
            <a href="{{ route('blog.index') }}" class="hover:text-blue-600 transition-colors">Blog</a>
            <svg class="w-4 h-4 mx-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M9 5l7 7-7 7"></path></svg>
            <span class="text-gray-900 font-medium truncate">{{ $blog->title }}</span>
        </nav>

        <!-- Article Header -->
        <header class="mb-8 md:mb-12 text-center">
            <span class="inline-block bg-blue-100 text-blue-700 text-xs font-bold px-4 py-1.5 rounded-full uppercase tracking-widest mb-4">ENT Health</span>
            <h1 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-extrabold text-gray-900 leading-tight mb-6">{{ $blog->title }}</h1>
            
            <div class="flex flex-wrap items-center justify-center gap-4 text-sm text-gray-500">
                <div class="flex items-center">
                    <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center mr-3">
                        <i class="fas fa-user text-blue-600 text-sm"></i>
                    </div>
                    <span class="font-bold text-gray-900">{{ $blog->author->name ?? 'ENT Care Center' }}</span>
                </div>
                <div class="h-4 w-px bg-gray-300 hidden sm:block"></div>
                <div class="flex items-center">
                    <i class="far fa-calendar-alt mr-2"></i>
                    {{ $blog->published_at->format('F d, Y') }}
                </div>
                <div class="h-4 w-px bg-gray-300 hidden sm:block"></div>
                <div class="flex items-center">
                    <i class="far fa-eye mr-2"></i>
                    {{ $blog->views }} views
                </div>
            </div>
        </header>

        <!-- Featured Image -->
        @if($blog->image)
        <div class="relative rounded-3xl overflow-hidden shadow-2xl mb-10 md:mb-16 transform hover:scale-[1.01] transition-transform duration-500">
            <img src="{{ asset('storage/' . $blog->image) }}" alt="{{ $blog->title }}" class="w-full h-auto max-h-[500px] object-cover">
            <div class="absolute inset-0 ring-1 ring-inset ring-black/10 rounded-3xl"></div>
        </div>
        @endif

        <!-- Article Body -->
        <article class="prose prose-lg sm:prose-xl max-w-none text-gray-700 leading-relaxed mb-12 md:mb-20">
            <div class="bg-blue-50/50 p-6 md:p-8 rounded-2xl border-l-4 border-blue-600 mb-8 italic text-lg md:text-xl text-gray-800 leading-relaxed">
                {{ $blog->short_description }}
            </div>

            <div class="blog-content space-y-6">
                {!! nl2br(e($blog->content)) !!}
            </div>
        </article>

        <!-- Social Share -->
        <div class="flex flex-col sm:flex-row items-center justify-between py-8 border-y border-gray-100 mb-12 md:mb-20">
            <h4 class="text-lg font-bold text-gray-900 mb-4 sm:mb-0">Share this article:</h4>
            <div class="flex gap-4">
                <a href="#" class="w-12 h-12 rounded-full bg-blue-600 text-white flex items-center justify-center hover:bg-blue-700 transition-all shadow-lg hover:shadow-blue-200 hover:-translate-y-1">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="#" class="w-12 h-12 rounded-full bg-sky-400 text-white flex items-center justify-center hover:bg-sky-500 transition-all shadow-lg hover:shadow-sky-200 hover:-translate-y-1">
                    <i class="fab fa-twitter"></i>
                </a>
                <a href="#" class="w-12 h-12 rounded-full bg-green-500 text-white flex items-center justify-center hover:bg-green-600 transition-all shadow-lg hover:shadow-green-200 hover:-translate-y-1">
                    <i class="fab fa-whatsapp"></i>
                </a>
                <a href="#" class="w-12 h-12 rounded-full bg-blue-700 text-white flex items-center justify-center hover:bg-blue-800 transition-all shadow-lg hover:shadow-blue-200 hover:-translate-y-1">
                    <i class="fab fa-linkedin-in"></i>
                </a>
            </div>
        </div>

        <!-- Recent Blog Posts -->
        @if($recentBlogs->count() > 0)
        <div class="mb-12 md:mb-20">
            <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-8 flex items-center">
                <span class="w-2 h-8 bg-blue-600 rounded-full mr-4"></span>
                Related Health Tips
            </h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($recentBlogs as $recent)
                <div class="bg-white rounded-2xl shadow-md hover:shadow-xl transition-all group overflow-hidden border border-gray-100">
                    @if($recent->image)
                    <div class="h-40 overflow-hidden">
                        <img src="{{ asset('storage/' . $recent->image) }}" alt="{{ $recent->title }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                    </div>
                    @endif
                    <div class="p-5">
                        <h4 class="font-bold text-gray-900 mb-2 group-hover:text-blue-600 transition-colors line-clamp-2">
                            <a href="{{ route('blog.show', $recent->slug) }}">{{ $recent->title }}</a>
                        </h4>
                        <p class="text-xs text-gray-500 mb-4">{{ $recent->published_at->format('M d, Y') }}</p>
                        <a href="{{ route('blog.show', $recent->slug) }}" class="text-sm font-bold text-blue-600 hover:text-blue-800 flex items-center group-hover:gap-1 transition-all">
                            Read More <i class="fas fa-chevron-right ml-1 text-[10px]"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        <!-- Author Bio Section -->
        <div class="bg-gradient-to-br from-indigo-50 to-blue-50 rounded-3xl p-6 md:p-8 flex flex-col md:flex-row items-center gap-6 md:gap-8 mb-12 md:mb-20 border border-indigo-100 shadow-inner">
            <div class="w-24 h-24 md:w-32 md:h-32 rounded-full bg-white p-2 shadow-xl flex-shrink-0">
                <div class="w-full h-full rounded-full bg-gradient-to-br from-blue-500 to-indigo-600 flex items-center justify-center text-white text-3xl font-bold">
                    {{ substr($blog->author->name ?? 'EC', 0, 2) }}
                </div>
            </div>
            <div class="text-center md:text-left">
                <h4 class="text-xl font-bold text-gray-900 mb-2">Written by {{ $blog->author->name ?? 'ENT Care Center' }}</h4>
                <p class="text-gray-600 leading-relaxed text-base">
                    Dedicated to providing the highest quality ENT care and sharing medical knowledge to help our community live healthier lives.
                </p>
                <div class="flex justify-center md:justify-start gap-4 mt-4">
                    <a href="#" class="text-indigo-600 hover:text-indigo-800 font-bold text-sm">Follow Expert</a>
                    <a href="{{ route('about') }}" class="text-indigo-600 hover:text-indigo-800 font-bold text-sm">About Author</a>
                </div>
            </div>
        </div>

        <!-- Comments / Engagement CTA -->
        <div class="text-center bg-gray-900 rounded-3xl p-8 md:p-12 text-white shadow-2xl overflow-hidden relative">
            <div class="absolute top-0 right-0 -mr-16 -mt-16 w-48 h-48 bg-blue-600 opacity-20 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 left-0 -ml-16 -mb-16 w-48 h-48 bg-indigo-600 opacity-20 rounded-full blur-3xl"></div>
            
            <h3 class="text-2xl md:text-3xl font-bold mb-4 relative z-10">Have questions about your health?</h3>
            <p class="text-gray-400 mb-8 text-lg relative z-10">Our specialists are here to help you. Schedule a consultation today.</p>
            <div class="flex flex-wrap justify-center gap-4 relative z-10">
                <a href="{{ route('appointment.create') }}" class="px-8 py-4 bg-blue-600 text-white rounded-full font-bold hover:bg-blue-700 transition-all shadow-lg hover:shadow-blue-900/40 transform hover:-translate-y-1">
                    Book Appointment
                </a>
                <a href="{{ route('contact.index') }}" class="px-8 py-4 bg-transparent border-2 border-white/30 text-white rounded-full font-bold hover:bg-white/10 transition-all transform hover:-translate-y-1">
                    Talk to Us
                </a>
            </div>
        </div>
    </div>
</section>
@endsection


